/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;

public class AttendanceCompileCardVo extends AttendanceCalculateMenuVo {

	private static final long serialVersionUID = -8482835887182137352L;

	// URLAJSt@CACSSt@C
	private static final String RETURN_URL = "/jsp/payroll/attendanceCompileCard.jsp";
	private static final String EXTRA_JS   = "/pub/payroll/js/attendanceCompileCard.js";
	private static final String EXTRA_CSS  = "/pub/payroll/css/attendanceCompileCard.css";

	// ʃTu^Cg
	public final String SUB_TITLE = CommonConst.TTL_ATT_CALCULATE_COMPILE;

	// p[^
	public static final String PRM_HID_YEAR		= "hidCompileYear";
	public static final String PRM_HID_MONTH 		= "hidCompileMonth";
	public static final String PRM_PLT_SECTION 	= "pltSection";
	public static final String PRM_TXT_KCODE 		= "txtKCode";

	// tB[h
	private String	hidCompileYear;
	private String	hidCompileMonth;
	private String	pltSection;
	private String	txtKCode;

	// tB[h(\̂)
	private String lblStartCompileDate;
	private String lblEndCompileDate;

	// tB[hyѐ
	public static final String NAM_CALCULATE_TARGET 	= CommonConst.NAM_CALCULATE_TARGET + CommonConst.NAM_ACCOUNTING_PERIOD;
	public static final String NAM_K_CODE 			= CommonConst.NAM_K_CODE;
	public static final String NAM_SECTION			= CommonConst.NAM_STATION;

	public static final int 	LEN_CODE 				= CommonConst.LEN_K_CODE;

	// 萔
	public static final int MODE_UPDATE 		= 1;
	public static final int MODE_IMPOSSIBLE 	= 2;

	// v_EXg
	public String[][] aryPltSection;

	// [h(1FXVA2FvZ񖳂)
	private int mode;

	/**
	 * RXgN^
	 */
	public AttendanceCompileCardVo() {
		super();
		setExtraCss(EXTRA_CSS);
		addExtraJs(EXTRA_JS);
		setRetUrl(RETURN_URL);
		mode = MODE_UPDATE;
		hidCompileYear 	= "";
		hidCompileMonth = "";
		pltSection 		= "";
		txtKCode 		= "";
	}

	/**
	 * p[^ݒ
	 */
	public void setParams(HttpServletRequest request) {
		hidCompileYear 	= request.getParameter(PRM_HID_YEAR);
		hidCompileMonth = request.getParameter(PRM_HID_MONTH);
		pltSection 		= request.getParameter(PRM_PLT_SECTION);
		txtKCode 		= request.getParameter(PRM_TXT_KCODE);
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}

	// ANZT\bh
	public String getHidCompileYear()		{ return hidCompileYear		; }
	public String getHidCompileMonth() 	    { return hidCompileMonth  	; }
	public String getPltSection() 			{ return pltSection			; }
	public String getTxtKCode() 			{ return txtKCode			; }

	public String getEscTxtKCode() 			{ return escapeHTML(txtKCode); }

	public void setHidCompileYear	(String hidCompileYear	){ this.hidCompileYear 	= hidCompileYear	; }
	public void setHidCompileMonth	(String hidCompileMonth	){ this.hidCompileMonth	= hidCompileMonth	; }
	public void setPltSection		(String pltSection		){ this.pltSection 		= pltSection		; }
	public void setTxtKCode		(String txtKCode		){ this.txtKCode 		= txtKCode			; }

	public String getEscLblEndCompileDate() 	{ return escapeHTML(lblEndCompileDate)		; }
	public String getEscLblStartCompileDate() 	{ return escapeHTML(lblStartCompileDate)	; }

	public void setLblEndCompileDate	(String lblEndCompileDate	){ this.lblEndCompileDate 	= lblEndCompileDate		; }
	public void setLblStartCompileDate	(String lblStartCompileDate	){ this.lblStartCompileDate	= lblStartCompileDate	; }

	public void setMode(int mode) { this.mode = mode; }
	public int getMode() { return mode; }

}
